<?php
/**
 * Report Reply Topic
 *
 * @package     AutomatorWP\Integrations\BuddyBoss\Triggers\Report_Reply_Topic
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyBoss_Report_Reply_Topic extends AutomatorWP_Integration_Trigger {

    public $integration = 'buddyboss';
    public $trigger = 'buddyboss_report_reply_topic';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User gets a reply in a topic reported', 'automatorwp-pro' ),
            'select_option'     => __( 'User gets a <strong>reply</strong> in a topic reported', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User gets a reply in a topic reported %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User gets a reply in a topic reported', 'automatorwp-pro' ),
            'action'            => 'bp_moderation_after_save',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_buddyboss_get_forum_tags(),
                automatorwp_buddyboss_get_topic_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param BP_Moderation  $args
     */
    public function listener( $args ) {

        // Bail if is not a reply
        if ( $args->item_type !== 'forum_reply' ) {
            return;
        }

        // To get the topic ID
        $topic_id = bbp_get_reply_topic_id( $args->item_id );

        // to get the reply data
        $reply_data = bbp_get_reply( $args->item_id );

        // To get the topic data
        $topic_data = bbp_get_topic( $topic_id );

        // To get the reported user
        $reported_user = absint( $reply_data->post_author );

        // To get the forum title
        $forum_title = bbp_get_forum_title( $topic_data->post_parent );

        // To get the topic title
        $topic_title = bbp_get_topic_title( $topic_id );

        // to get topic URL
        $topic_url = get_permalink( $topic_id );

        // Trigger the favorite an activity
        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $reported_user,
            'post_id'       => $topic_data->ID,
            'topic_id'      => $topic_data->ID,
            'forum_id'      => $topic_data->post_parent,
            'forum_title'   => $forum_title,
            'topic_title'   => $topic_title,
            'topic_url'     => $topic_url,
        ) );

    }

    /**
     * Register the required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_trigger_log_meta', array( $this, 'log_meta' ), 10, 6 );

        parent::hooks();
    }

    /**
     * Trigger custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return array
     */
    function log_meta( $log_meta, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Bail if action type don't match this action
        if( $trigger->type !== $this->trigger ) {
            return $log_meta;
        }

        $log_meta['forum_id'] = ( isset( $event['forum_id'] ) ? $event['forum_id'] : '' );
        $log_meta['forum_title'] = ( isset( $event['forum_title'] ) ? $event['forum_title'] : '' );
        $log_meta['topic_title'] = ( isset( $event['topic_title'] ) ? $event['topic_title'] : '' );
        $log_meta['topic_url'] = ( isset( $event['topic_url'] ) ? $event['topic_url'] : '' );
        
        return $log_meta;

    }

}

new AutomatorWP_BuddyBoss_Report_Reply_Topic();